﻿//////////////////////////////////////////////
// LayoutResizeHandle.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkMaths
{
	class Rectangle ;
}

namespace nkWinUi
{
	class Layout ;
}

/// Includes ---------------------------------

// Standards
#include <functional>

/// Class ------------------------------------

namespace nkWinUi
{
	class LayoutResizeHandle
	{
		public :

			// Destructor
			virtual ~LayoutResizeHandle () ;

			// Getters
			Layout* getParentLayout () const ;
			void* getUserData () const ;
			bool getSideHandle () const ;
			virtual bool getInitialized () const = 0 ;
			virtual const nkMaths::Rectangle& getArea () const = 0 ;

			// Setters
			void setParentLayout (Layout* value) ;
			void setUserData (void* value) ;
			void setSideHandle (bool value) ;
			void setSizingActivationCallback (const std::function<void (LayoutResizeHandle*, bool)>& value) ;
			void setChangeCallback (const std::function<void (LayoutResizeHandle*, float, float)>& value) ;
			virtual void setArea (const nkMaths::Rectangle& value) = 0 ;
			virtual void setVisibility (bool value) = 0 ;

			// Init
			virtual void load () = 0 ;
			virtual void unload () = 0 ;

		protected :

			// Functions
			// Constructor
			LayoutResizeHandle () noexcept ;

		protected :

			// Attributes
			// Parent
			Layout* _parentLayout ;
			// User data depending on layout
			void* _userData ;

			// Change callback
			std::function<void (LayoutResizeHandle*, bool)> _sizingActivationCallback ;
			std::function<void (LayoutResizeHandle*, float, float)> _changeCallback ;

			// Flags
			bool _sideHandle ;
	} ;
}